# Coverage - DVA - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Coverage - DVA**

## Example Coverage: Coverage - DVA

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md)

**identifier**: DVA Number/QX521750

**status**: Active

**type**: veteran health program

**beneficiary**: [Elijah KEN SCOTT (official) Male, DoB: 1986-11-28 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647204)](Patient-scott-elijah-ken.md)

**payor**: Department of Veterans' Affairs (Identifier: ABN/23964290824)



## Resource Content

```json
{
  "resourceType" : "Coverage",
  "id" : "coverage-dva",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-coverage"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "DVAU",
            "display" : "DVA Number"
          }
        ],
        "text" : "DVA Number"
      },
      "system" : "http://ns.electronichealth.net.au/id/dva",
      "value" : "QX521750"
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "code" : "VET",
        "display" : "veteran health program"
      }
    ]
  },
  "beneficiary" : {
    "reference" : "Patient/scott-elijah-ken"
  },
  "payor" : [
    {
      "identifier" : {
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
              "code" : "XX"
            }
          ],
          "text" : "ABN"
        },
        "system" : "http://hl7.org.au/id/abn",
        "value" : "23964290824"
      },
      "display" : "Department of Veterans' Affairs"
    }
  ]
}

```
