# AU eRequesting Filler CapabilityStatement - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU eRequesting Filler CapabilityStatement**

## CapabilityStatement: AU eRequesting Filler CapabilityStatement 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/ereq/CapabilityStatement/au-erequesting-filler | *Version*:1.0.0 | |
| * Standards status: *[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://build.fhir.org/ig/hl7au/au-fhir-base/generalguidance.html#maturity-levels): 1 | *Computable Name*:AUeRequestingFillerCapabilityStatement |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This CapabilityStatement describes the basic rules for the [AU eRequesting Filler actor](ActorDefinition-au-erequesting-actor-filler.md) that is responsible for finding and retrieving diagnostic request fulfilments so that service providers can fulfil them. The complete list of FHIR profiles, RESTful operations, and search parameters supported by the AU eRequesting Filler actor are defined in this CapabilityStatement. 

### Summary of Must Support and References Between Profiles

The table below identifies where a Profile has a Must Support reference to other profiles or resources (i.e., Target Profiles). This list is provided to clarify where additional profiles or resources may need to be supported if the AU eRequesting Filler actor supports a particular resource.

| | | |
| :--- | :--- | :--- |
| CommunicationRequest | [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md),[AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md),[AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md) | [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md),[AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md),[AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md),[AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md) |
| Condition | [AU Core Condition](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-condition.html) | [AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html) |
| Consent | [AU eRequesting MHR Consent Withdrawal](StructureDefinition-au-erequesting-mhrconsentwithdrawal.md) | [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md),[AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md),[AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md) |
| Coverage | [AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md) | [AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md),[AU Core RelatedPerson](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-relatedperson.html) |
| Device | [Device](https://hl7.org/fhir/R4/device.html) | - |
| DocumentReference | [AU eRequesting Clinical Context DocumentReference](StructureDefinition-au-erequesting-clinicalcontext-documentreference.md) | [AU Core RelatedPerson](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-relatedperson.html),[AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md),[AU eRequesting Practitioner](StructureDefinition-au-erequesting-practitioner.md),[AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md) |
| Encounter | [AU Core Encounter](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-encounter.html) | [AU Core Condition](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-condition.html),[AU Core Location](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-location.html),[AU Core Organization](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-organization.html),[AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html),[AU Core Practitioner](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-practitioner.html),[AU Core PractitionerRole](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-practitionerrole.html),[AU Core Procedure](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-procedure.html),[AU Core RelatedPerson](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-relatedperson.html),[Observation](http://hl7.org/fhir/R4/observation.html) |
| Encounter | [AU eRequesting Encounter](StructureDefinition-au-erequesting-encounter.md) | [AU Core Condition](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-condition.html),[AU Core Location](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-location.html),[AU Core Procedure](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-procedure.html),[AU Core RelatedPerson](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-relatedperson.html),[AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md),[AU eRequesting Practitioner](StructureDefinition-au-erequesting-practitioner.md),[AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md),[Observation](http://hl7.org/fhir/R4/observation.html) |
| Location | [AU Core Location](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-location.html) | [AU Core Organization](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-organization.html) |
| Observation | [Observation Pregnancy - Expected Delivery Date (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Observation-pregnancy-edd-uv-ips.html) | [Patient (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Patient-uv-ips.html) |
| Observation | [Observation Pregnancy - Status (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Observation-pregnancy-status-uv-ips.html) | [Observation Pregnancy - Expected Delivery Date (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Observation-pregnancy-edd-uv-ips.html),[Patient (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Patient-uv-ips.html) |
| Organization | [AU Core Organization](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-organization.html) | - |
| Organization | [AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md) | - |
| Organization | [Organization](https://hl7.org/fhir/R4/organization.html) | - |
| Patient | [AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html) | - |
| Patient | [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md) | - |
| Patient | [Patient](https://hl7.org/fhir/R4/patient.html) | - |
| Patient | [Patient (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Patient-uv-ips.html) | - |
| Practitioner | [AU Core Practitioner](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-practitioner.html) | - |
| Practitioner | [AU eRequesting Practitioner](StructureDefinition-au-erequesting-practitioner.md) | - |
| Practitioner | [Practitioner](https://hl7.org/fhir/R4/practitioner.html) | - |
| PractitionerRole | [AU Core PractitionerRole](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-practitionerrole.html) | [AU Core Organization](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-organization.html),[AU Core Practitioner](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-practitioner.html) |
| PractitionerRole | [AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md) | [AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md),[AU eRequesting Practitioner](StructureDefinition-au-erequesting-practitioner.md) |
| PractitionerRole | [PractitionerRole](https://hl7.org/fhir/R4/practitionerrole.html) | - |
| Procedure | [AU Core Procedure](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-procedure.html) | [AU Core Condition](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-condition.html),[AU Core Encounter](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-encounter.html),[AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html),[AU Core Procedure](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-procedure.html),[DocumentReference](http://hl7.org/fhir/R4/documentreference.html),[Observation](http://hl7.org/fhir/R4/observation.html) |
| RelatedPerson | [AU Core RelatedPerson](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-relatedperson.html) | [AU Core Patient](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-patient.html) |
| RelatedPerson | [RelatedPerson](https://hl7.org/fhir/R4/relatedperson.html) | - |
| ServiceRequest | [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md),[AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | [AU eRequesting Clinical Context DocumentReference](StructureDefinition-au-erequesting-clinicalcontext-documentreference.md),[AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md),[AU eRequesting Encounter](StructureDefinition-au-erequesting-encounter.md),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md),[AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md),[Observation Pregnancy - Status (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Observation-pregnancy-status-uv-ips.html) |
| Task | [AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md) | [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md),[AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md),[AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md),[AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md),[AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md),[AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md) |
| Task | [AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md) | [AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md),[AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md),[AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md),[AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md),[AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md) |
| Task | [AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md) | [AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md),[AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md),[AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md) |

 [Raw OpenAPI-Swagger Definition file](au-erequesting-filler.openapi.json) | [Download](au-erequesting-filler.openapi.json) 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "au-erequesting-filler",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/ereq/ImplementationGuide/hl7.fhir.au.ereq"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/ereq/CapabilityStatement/au-erequesting-filler",
  "version" : "1.0.0",
  "name" : "AUeRequestingFillerCapabilityStatement",
  "title" : "AU eRequesting Filler CapabilityStatement",
  "status" : "active",
  "date" : "2026-02-11T06:15:07+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG"
        }
      ]
    },
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This CapabilityStatement describes the basic rules for the [AU eRequesting Filler actor](ActorDefinition-au-erequesting-actor-filler.html) that is responsible for finding and retrieving diagnostic request fulfilments so that service providers can fulfil them. The complete list of FHIR profiles, RESTful operations, and search parameters supported by the AU eRequesting Filler actor are defined in this CapabilityStatement.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved.",
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["json", "xml"],
  "_format" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHOULD"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    }
  ],
  "patchFormat" : ["application/json-patch+json"],
  "_patchFormat" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    }
  ],
  "implementationGuide" : [
    "http://hl7.org.au/fhir/ImplementationGuide/hl7.fhir.au.base",
    "http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core"
  ],
  "_implementationGuide" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    }
  ],
  "rest" : [
    {
      "mode" : "client",
      "documentation" : "The AU eRequesting Filler actor **SHALL**:\n1. Support all resource profiles required by the AU eRequesting Filler actor for finding and retrieving diagnostic request fulfilments so that service providers can fulfil them, as defined in this CapabilityStatement. \n1. Implement the RESTful behavior according to the FHIR specification.",
      "security" : {
        "description" : "None defined."
      },
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "CommunicationRequest",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-copyto",
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-patient",
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-urgentprovider"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The AU eRequesting Filler actor **SHALL** support the CommunicationRequest resource, the AU eRequesting profiles, and the conformance expectations for the CommunicationRequest resource.\n\nWhere a CommunicationRequest profile is defined for a specific purpose that profile **SHALL** be used:\n* Communication requests about providing a copy of the report to a patient or clinician **SHALL** use the AU eRequesting CommunicationRequest CopyTo profile\n* Communication requests about communication with a patient from a filler **SHALL** use the AU eRequesting CommunicationRequest Patient profile\n* Communication requests about communication from a filler to a clinical provider to notify them of urgent results **SHALL** use the AU eRequesting CommunicationRequest Urgent Provider profile",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Condition",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-condition"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Filler actor supports the Condition resource, the AU eRequesting Filler actor **SHALL** support the AU Core profile, and the conformance expectations for the Condition resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Consent",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-mhrconsentwithdrawal"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The AU eRequesting Filler actor **SHALL** support the Consent resource, the AU eRequesting MHR Consent Withdrawal profile, and the conformance expectations for the Consent resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Coverage",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-coverage"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The AU eRequesting Filler actor **SHALL** support the Coverage resource, the AU eRequesting profile, and the conformance expectations for the Coverage resource.\n\nWhen using one of the below Coverage types, at least one of the corresponding identifiers **SHOULD** be populated:\n\n| Coverage Type | Code | Identifier |\n| ----------- | ----------- | ----------- |\n| Medicare | PUBLICPOL | [AU Medicare Card Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-medicarecardnumber.html)|\n| Department of Veterans Affairs (DVA) | VET | [AU DVA Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-dvanumber.html) |\n| Concession | payconc | [AU Pensioner Concession Card Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-pensionerconcessioncardnumber.html), [AU Commonwealth Seniors Health Card Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-cwlthseniorshealthcardnumber.html) , [AU Health Care Card Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-healthcarecardnumber.html)|\n| Private health insurance | HIP | [AU Insurance Member Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-insurancemembernumber.html) |\n| Private (self funded) | pay | N/A |",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Device",
          "documentation" : "The AU eRequesting Filler actor **SHALL** support the Device resource and the conformance expectations for the Device resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "DocumentReference",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-clinicalcontext-documentreference"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The AU eRequesting Filler actor **SHALL** support the DocumentReference resource, the AU eRequesting profile, and the conformance expectations for the DocumentReference resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Encounter",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-encounter",
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The AU eRequesting Filler actor **SHALL** support the Encounter resource, the AU eRequesting profile, the AU Core profile, and the conformance expectations for the Encounter resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Location",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-location"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Filler actor supports the Location resource, the AU eRequesting Filler actor **SHALL** support the AU Core profile, and the conformance expectations for the Location resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Observation",
          "supportedProfile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-status-uv-ips",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-edd-uv-ips"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The AU eRequesting Filler actor **SHALL** support the Observation resource, the Observation Pregnancy - Status (IPS), the Observation Pregnancy - Expected Delivery Date (IPS) profiles and the conformance expectations for the Observation resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Organization",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-organization",
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The AU eRequesting Filler actor **SHALL** support the Organization resource, the AU eRequesting profile, the AU Core profile, and the conformance expectations for the Organization resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Organization-identifier",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Patient",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-patient",
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Patient-uv-ips"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The AU eRequesting Filler actor **SHALL** support the Patient resource, the AU eRequesting profile, the AU Core profile, the Patient (IPS) profile and the conformance expectations for the Patient resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Patient-identifier",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Practitioner",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-practitioner",
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The AU eRequesting Filler actor **SHALL** support the Practitioner resource, the AU eRequesting profile, the AU Core profile, and the conformance expectations for the Practitioner resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Practitioner-identifier",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "PractitionerRole",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-practitionerrole",
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The AU eRequesting Filler actor **SHALL** support the PractitionerRole resource, the AU eRequesting profile, the AU Core profile, and the conformance expectations for the PractitionerRole resource.\n\nThe AU eRequesting Filler actor **MAY** support the `_include` parameter for `PractitionerRole:practitioner` and `PractitionerRole:organization`",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchInclude" : [
            "PractitionerRole:practitioner",
            "PractitionerRole:organization"
          ],
          "_searchInclude" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/PractitionerRole-identifier",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Procedure",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-procedure"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Filler actor supports the Procedure resource, the AU eRequesting Filler actor **SHALL** support the AU Core profile, and the conformance expectations for the Procedure resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "RelatedPerson",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-relatedperson"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Filler actor supports the RelatedPerson resource, the AU eRequesting Filler actor **SHALL** support the AU Core profile, and the conformance expectations for the RelatedPerson resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "ServiceRequest",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-path",
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-imag"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            }
          ],
          "documentation" : "The AU eRequesting Filler actor **SHALL** support the ServiceRequest resource, at least one AU eRequesting Diagnostic Request profile, and the conformance expectations for the ServiceRequest resource.\n\nThe AU eRequesting Filler actor **MAY** support the `_include` parameter for `ServiceRequest:patient`, `ServiceRequest:requester`, `ServiceRequest:encounter` and `ServiceRequest:supporting-info`.\n\nWhere a profile is defined for a specific domain that profile **SHALL** be used: Pathology requests **SHALL** use AU eRequesting Pathology Request profile; Imaging requests **SHALL** use AU eRequesting Imaging Request profile.\n\nInformation recorded in `ServiceRequest.note` **SHALL NOT** duplicate or overlap with clinical context captured in `ServiceRequest.supportingInfo:clinicalContext`, or with any other information recorded in the ServiceRequest.\n\n[AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.html):\n\nPlacer systems **SHALL** populate `ServiceRequest.code.text` so that fillers can at least display the service requested, even if they do not recognise the code supplies.\n\nPlacer systems **SHALL** adhere to the following order of preference when populating the `ServiceRequest.code`:\n* A code selected from the [RANZCR Radiology Referral](https://www.healthterminologies.gov.au/integration/R4/fhir/ValueSet/ranzcr-radiology-referral-1) value set is the preferred option\n* A code selected from the SNOMED CT [Imaging Procedure](https://www.healthterminologies.gov.au/integration/R4/fhir/ValueSet/imaging-procedure-1) value set is the second most preferred option\n* A local code is preferred over free text, preferably from a published and accessible FHIR code system​\n* Free text is the least preferred option which should not be used if a local code is known\n\n[AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.html):\n\nPlacer systems **SHALL** populate `ServiceRequest.code.text` so that fillers can at least display the service requested, even if they do not recognise the code supplied.\n\nPlacer systems **SHALL** adhere to the following order of preference when populating the `ServiceRequest.code`:\n* A code selected from the [RCPA - SPIA Requesting Pathology Terminology Reference Set](https://www.healthterminologies.gov.au/integration/R4/fhir/ValueSet/spia-requesting-refset-3) value set is the preferred option\n* A code selected from the SNOMED CT [Pathology Procedure](https://www.healthterminologies.gov.au/integration/R4/fhir/ValueSet/pathology-procedure-1) value set is the second most preferred option\n* A local code is preferred over free text, preferably from a published and accessible FHIR code system​\n\n* Free text is the least preferred option which should not be used if a local code is known",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchInclude" : [
            "ServiceRequest:patient",
            "ServiceRequest:requester",
            "ServiceRequest:encounter",
            "ServiceRequest:supporting-info"
          ],
          "_searchInclude" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "requisition",
              "definition" : "http://hl7.org/fhir/SearchParameter/ServiceRequest-requisition",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "supporting-info",
              "definition" : "http://hl7.org.au/fhir/SearchParameter/servicerequest-supporting-info",
              "type" : "reference"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                },
                {
                  "url" : "required",
                  "valueString" : "_lastUpdated"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                },
                {
                  "url" : "required",
                  "valueString" : "owner"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                },
                {
                  "url" : "required",
                  "valueString" : "owner"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                },
                {
                  "url" : "required",
                  "valueString" : "requester"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "Task",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-group",
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-diagnosticrequest",
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-communicationrequest"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The AU eRequesting Filler actor **SHALL** support the Task resource, the AU eRequesting profiles, and the conformance expectations for the Task resource.\n\nThe AU eRequesting Filler actor **MAY** support the `_include` parameter for `Task:patient`, `Task:requester`, `Task:owner`, `Task:focus`.\n\nThe AU eRequesting Filler actor **MAY** support the `_revinclude` parameter for `Task:part-of`.\n\nWhere a task profile is defined for a specific purpose that profile **SHALL** be used:\n\n* Group tasks **SHALL** use AU eRequesting Task Group profile\n\n* Diagnostic request tasks **SHALL** use AU eRequesting Task Diagnostic Request profile\n\n* Communication request tasks **SHALL** use AU eRequesting Task Communication Request profile",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchInclude" : ["Task:patient", "Task:requester", "Task:owner", "Task:focus"],
          "_searchInclude" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            }
          ],
          "searchRevInclude" : ["Task:part-of"],
          "_searchRevInclude" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_lastUpdated",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-lastUpdated",
              "type" : "date",
              "documentation" : "The AU eRequesting Filler actor **MAY** support `multipleAnd`. The AU eRequesting Filler actor **MAY** support search comparators `gt`, `lt`, `ge`, `le`."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_tag",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-tag",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "focus",
              "definition" : "http://hl7.org/fhir/SearchParameter/Task-focus",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "group-identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Task-group-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "owner",
              "definition" : "http://hl7.org/fhir/SearchParameter/Task-owner",
              "type" : "reference",
              "documentation" : "The AU eRequesting Filler actor **MAY** support chained search owner.identifier using HPI-O and ABN identifiers as defined in the AU Core Organization profile."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "part-of",
              "definition" : "http://hl7.org/fhir/SearchParameter/Task-part-of",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The AU eRequesting Filler actor **MAY** support chained search patient.identifier using IHI, Medicare Number, and DVA Number identifiers as defined in the AU Core Patient profile."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "requester",
              "definition" : "http://hl7.org/fhir/SearchParameter/Task-requester",
              "type" : "reference",
              "documentation" : "The AU eRequesting Filler actor **MAY** support chained search requester.identifier using Medicare Provider Number identifier as defined in the AU Core PractitionerRole profile."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/Task-status",
              "type" : "token",
              "documentation" : "The AU eRequesting Filler actor **MAY** support `multipleOr`."
            }
          ]
        }
      ],
      "interaction" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "code" : "transaction"
        }
      ]
    }
  ]
}

```
